using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace SPStudio
{
	/// <summary>
	/// Home for OpenGLPanel.
	/// </summary>
	public class VoxelView : System.Windows.Forms.Form
	{
		#region Public Vars
		public OpenGLPanel view = null;
		#endregion

		#region Windows Generated Vars
		private System.ComponentModel.Container components = null;
		#endregion

		#region Constructor
		/// <summary>
		/// Send finalized voxels to the 
		/// OpenGLPanel for display.
		/// </summary>
		/// <param name="Parent"></param>
		public VoxelView(Workspace Parent)
		{
			InitializeComponent();

			this.ClientSize = Parent.getSize();

			view = new OpenGLPanel(Parent.finalizedVoxels,Parent);
			view.Dock = DockStyle.Fill;
			Controls.Add( view );
			MdiParent = Parent.desktop;
			Show();
		}
		#endregion

		#region Overridden Refresh To Force OpenGLPanel Redraw
		/// <summary>
		/// Overridden Refresh calls the glDraw method
		/// within the OpenGLPanel.
		/// </summary>
		public override void Refresh()
		{
			base.Refresh ();
			view.glDraw();
		}
		#endregion

		#region Dispose Method, Includes Disposal Of OpenGLPanel
		/// <summary>
		/// Clean up any resources being used.
		/// Includes the disposal of the OpenGLPanel.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				view.Dispose();
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			// 
			// VoxelView
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 266);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D;
			this.MaximizeBox = false;
			this.Name = "VoxelView";
			this.Text = "Voxel View";

		}
		#endregion
	}
}
